﻿var panelTemplates = {
    context: $(".v-panelTemplates"),
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".v-panelTemplatesTable", this.context).a4datatable({
            height: "full",
            stateKey: "SettingsPanelTemplates",
            ajaxAction: a4.getAction("GetPanelTemplates", "Home", "Panel"),
            columns: [
                { "Name": "Id", "Title": resources.Id },
                { "Name": "Type", "Title": resources.Type, "HideInSelector": true },
                { "Name": "TemplateName", "Title": resources.Name, "HideInSelector": true },
                { "Name": "Language", "Title": resources.Language },
                { "Name": "Default", "Title": resources.Default, "Label": "DefaultLabel" },
                { "Name": "ModifiedBy", "Title": resources.ModifiedBy },
                { "Name": "ModifiedOn", "Title": resources.ModifiedOn }
            ],            
            toolBarItems: panelTemplates.getToolBarItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;

                if (action == "delete") {
                    panelTemplates.deleteItems(_.pluck(rows, "Id"));
                }
            },
            contextMenuItems: panelTemplates.getContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                if (action == "edit") {
                    modalDialog.showWindow(a4.getAction("EditEmailTemplate", "Home", "Panel", { id: row.Id }), 530, 600, { afterClose: function () { panelTemplates.refreshDataTable(); } });
                }
                else if (action == "delete") {
                    panelTemplates.deleteItems(row.Id);
                }
            },
            localizableTexts: { "Search": resources.SearchEmailTemplates }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-addTemplate", function () {
            modalDialog.showWindow(a4.getAction("EditEmailTemplate", "Home", "Panel"), 530, 600, { afterClose: function () { panelTemplates.refreshDataTable(); } });
        });
    },
    refreshDataTable: function () {
        this.datatable.a4datatable("refresh");
    },
    deleteItems: function (items) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteItemResources, function () {            
            a4.callServerMethod(a4.getAction("DeleteTemplates", "Home", "Panel"), { ids: items },
                function (result) {
                    panelTemplates.refreshDataTable();
                });
        }, 250, 500, true, { "count": itemsCount });
    },
    canModifyPanel: $("#CanModifyPanel").val() == "True",
    getToolBarItems: function () {
        var items = [];

        if (this.canModifyPanel) {
            items.push({ "Action": "delete", "Label": resources.Delete });
        }

        return items;
    },
    getContextMenuItems: function () {
        var items = [];

        if (this.canModifyPanel) {
            items.push({ "Action": "edit", "Label": resources.Edit });
            items.push({ "Action": "delete", "Label": resources.Delete });
        }

        return items;
    }
}

$(document).ready(function () {
    if (panelTemplates.context.length > 0) {
        panelTemplates.initializeDataTable();
        panelTemplates.bindEvents();
    }
});